<div class="carousel-wrapper">
  <div class="carousel">
    <!-- Capas dos livros -->
    <div class="book-cover" style="background-image: url('img1.jpg');"></div>
    <div class="book-cover" style="background-image: url('img2.jpg');"></div>
    <!-- ... -->
  </div>

  <div class="carousel-controls">
    <button class="carousel-nav left" onclick="scrollCarousel(-1)">←</button>
    <button class="carousel-nav right" onclick="scrollCarousel(1)">→</button>
  </div>
</div>


<section id="comments">
  <h3>Comentários</h3>
  <div id="comment-list"></div>
  <form id="comment-form">
    <input type="text" id="comment-input" placeholder="Escreva um comentário..." required />
    <button type="submit">Enviar</button>
  </form>
</section>

<script>
(() => {
  const books = [
    {
      id: 'pride',
      title: 'Orgulho e Preconceito',
      author: 'Jane Austen',
      cover: 'https://upload.wikimedia.org/wikipedia/commons/1/15/PrideAndPrejudiceTitlePage.jpg',
      content: `
        <p>É uma verdade universalmente reconhecida que um homem solteiro em posse de uma grande fortuna precisa de uma esposa.</p>
        <p>No entanto, pouco se sabe sobre os sentimentos ou opiniões de tal homem ao se mudar para uma nova vizinhança.</p>
        <p>Mas essa verdade é tão bem estabelecida que é aceita como base suficiente para a introdução dessa história.</p>
        <p>A família Bennet vivia numa modesta propriedade rural, mas seus membros tinham grandes preocupações quanto a casar suas filhas.</p>
      `
    },
    {
      id: 'metamorphosis1',
      title: 'A Metamorfose',
      author: 'Franz Kafka',
      cover: 'https://upload.wikimedia.org/wikipedia/commons/c/c3/Metamorphosis_%281917%29_%28Deutsche_Verlags-Anstalt%29_-_title_page.jpg',
      content: `
        <p>Quando Gregor Samsa acordou certa manhã após um sono agitado, encontrou-se em sua cama transformado em um enorme inseto.</p>
        <p>Esta estranha metamorfose trazia um conflito entre sua condição física e sua consciência humana.</p>
        <p>Isolado e incompreendido pela família, Gregor enfrentava o choque e as limitações de sua nova forma.</p>
        <p>A obra explora temas profundos sobre identidade, alienação e a condição humana.</p>
      `
    },
    {
      id: 'metamorphosis2',
      title: 'A Metamorfose',
      author: 'Franz Kafka',
      cover: 'https://upload.wikimedia.org/wikipedia/commons/c/c3/Metamorphosis_%281917%29_%28Deutsche_Verlags-Anstalt%29_-_title_page.jpg',
      content: `
        <p>Quando Gregor Samsa acordou certa manhã após um sono agitado, encontrou-se em sua cama transformado em um enorme inseto.</p>
        <p>Esta estranha metamorfose trazia um conflito entre sua condição física e sua consciência humana.</p>
        <p>Isolado e incompreendido pela família, Gregor enfrentava o choque e as limitações de sua nova forma.</p>
        <p>A obra explora temas profundos sobre identidade, alienação e a condição humana.</p>
      `
    },
    {
      id: 'metamorphosis3',
      title: 'A Metamorfose',
      author: 'Franz Kafka',
      cover: 'https://upload.wikimedia.org/wikipedia/commons/c/c3/Metamorphosis_%281917%29_%28Deutsche_Verlags-Anstalt%29_-_title_page.jpg',
      content: `
        <p>Quando Gregor Samsa acordou certa manhã após um sono agitado, encontrou-se em sua cama transformado em um enorme inseto.</p>
        <p>Esta estranha metamorfose trazia um conflito entre sua condição física e sua consciência humana.</p>
        <p>Isolado e incompreendido pela família, Gregor enfrentava o choque e as limitações de sua nova forma.</p>
        <p>A obra explora temas profundos sobre identidade, alienação e a condição humana.</p>
      `
    },
    {
      id: 'metamorphosis4',
      title: 'A Metamorfose',
      author: 'Franz Kafka',
      cover: 'https://upload.wikimedia.org/wikipedia/commons/c/c3/Metamorphosis_%281917%29_%28Deutsche_Verlags-Anstalt%29_-_title_page.jpg',
      content: `
        <p>Quando Gregor Samsa acordou certa manhã após um sono agitado, encontrou-se em sua cama transformado em um enorme inseto.</p>
        <p>Esta estranha metamorfose trazia um conflito entre sua condição física e sua consciência humana.</p>
        <p>Isolado e incompreendido pela família, Gregor enfrentava o choque e as limitações de sua nova forma.</p>
        <p>A obra explora temas profundos sobre identidade, alienação e a condição humana.</p>
      `
    },
    {
      id: 'metamorphosis5',
      title: 'A Metamorfose',
      author: 'Franz Kafka',
      cover: 'https://upload.wikimedia.org/wikipedia/commons/c/c3/Metamorphosis_%281917%29_%28Deutsche_Verlags-Anstalt%29_-_title_page.jpg',
      content: `
        <p>Quando Gregor Samsa acordou certa manhã após um sono agitado, encontrou-se em sua cama transformado em um enorme inseto.</p>
        <p>Esta estranha metamorfose trazia um conflito entre sua condição física e sua consciência humana.</p>
        <p>Isolado e incompreendido pela família, Gregor enfrentava o choque e as limitações de sua nova forma.</p>
        <p>A obra explora temas profundos sobre identidade, alienação e a condição humana.</p>
      `
    },
    {
      id: 'metamorphosis6',
      title: 'A Metamorfose',
      author: 'Franz Kafka',
      cover: 'https://upload.wikimedia.org/wikipedia/commons/c/c3/Metamorphosis_%281917%29_%28Deutsche_Verlags-Anstalt%29_-_title_page.jpg',
      content: `
        <p>Quando Gregor Samsa acordou certa manhã após um sono agitado, encontrou-se em sua cama transformado em um enorme inseto.</p>
        <p>Esta estranha metamorfose trazia um conflito entre sua condição física e sua consciência humana.</p>
        <p>Isolado e incompreendido pela família, Gregor enfrentava o choque e as limitações de sua nova forma.</p>
        <p>A obra explora temas profundos sobre identidade, alienação e a condição humana.</p>
      `
    },
    {
      id: 'metamorphosis7',
      title: 'A Metamorfose',
      author: 'Franz Kafka',
      cover: 'https://upload.wikimedia.org/wikipedia/commons/c/c3/Metamorphosis_%281917%29_%28Deutsche_Verlags-Anstalt%29_-_title_page.jpg',
      content: `
        <p>Quando Gregor Samsa acordou certa manhã após um sono agitado, encontrou-se em sua cama transformado em um enorme inseto.</p>
        <p>Esta estranha metamorfose trazia um conflito entre sua condição física e sua consciência humana.</p>
        <p>Isolado e incompreendido pela família, Gregor enfrentava o choque e as limitações de sua nova forma.</p>
        <p>A obra explora temas profundos sobre identidade, alienação e a condição humana.</p>
      `
    },
    {
      id: 'metamorphosis8',
      title: 'A Metamorfose',
      author: 'Franz Kafka',
      cover: 'https://upload.wikimedia.org/wikipedia/commons/c/c3/Metamorphosis_%281917%29_%28Deutsche_Verlags-Anstalt%29_-_title_page.jpg',
      content: `
        <p>Quando Gregor Samsa acordou certa manhã após um sono agitado, encontrou-se em sua cama transformado em um enorme inseto.</p>
        <p>Esta estranha metamorfose trazia um conflito entre sua condição física e sua consciência humana.</p>
        <p>Isolado e incompreendido pela família, Gregor enfrentava o choque e as limitações de sua nova forma.</p>
        <p>A obra explora temas profundos sobre identidade, alienação e a condição humana.</p>
      `
    },
    {
      id: 'metamorphosis9',
      title: 'A Metamorfose',
      author: 'Franz Kafka',
      cover: 'https://upload.wikimedia.org/wikipedia/commons/c/c3/Metamorphosis_%281917%29_%28Deutsche_Verlags-Anstalt%29_-_title_page.jpg',
      content: `
        <p>Quando Gregor Samsa acordou certa manhã após um sono agitado, encontrou-se em sua cama transformado em um enorme inseto.</p>
        <p>Esta estranha metamorfose trazia um conflito entre sua condição física e sua consciência humana.</p>
        <p>Isolado e incompreendido pela família, Gregor enfrentava o choque e as limitações de sua nova forma.</p>
        <p>A obra explora temas profundos sobre identidade, alienação e a condição humana.</p>
      `
    }
  ];

  const carousel = document.querySelector('.carousel');
  const mainTitle = document.querySelector('main h2');
  const bookContent = document.getElementById('book-content');
  const commentList = document.getElementById('comment-list');
  const commentForm = document.getElementById('comment-form');
  const commentInput = document.getElementById('comment-input');

  const COMMENT_STORAGE_PREFIX = 'book_comments_';
  let activeBookId = null;

  function loadComments(bookId) {
    try {
      const saved = localStorage.getItem(COMMENT_STORAGE_PREFIX + bookId);
      return saved ? JSON.parse(saved) : [];
    } catch {
      return [];
    }
  }

  function saveComments(bookId, comments) {
    localStorage.setItem(COMMENT_STORAGE_PREFIX + bookId, JSON.stringify(comments));
  }

  function renderComments(bookId) {
    const comments = loadComments(bookId);
    commentList.innerHTML = comments.length
      ? comments.map(c => `<p>${c}</p>`).join('')
      : `<p style="color:#888;">Nenhum comentário ainda. Seja o primeiro!</p>`;
  }

  function clearActiveCover() {
    document.querySelectorAll('.book-cover').forEach(c => c.classList.remove('active'));
  }

  function setActiveBook(bookId) {
    if (activeBookId === bookId) return;

    const book = books.find(b => b.id === bookId);
    if (!book) return;

    activeBookId = bookId;

    clearActiveCover();
    const activeCoverDiv = document.querySelector(`.book-cover[data-id="${bookId}"]`);
    if (activeCoverDiv) activeCoverDiv.classList.add('active');

    mainTitle.textContent = `${book.title} — ${book.author}`;
    bookContent.innerHTML = book.content;
    bookContent.focus();

    renderComments(bookId);
    commentInput.value = '';
  }

  function createCarouselCovers() {
    books.forEach(book => {
      const div = document.createElement('div');
      div.className = 'book-cover';
      div.setAttribute('role', 'listitem');
      div.setAttribute('tabindex', '0');
      div.setAttribute('aria-label', `${book.title} por ${book.author}`);
      div.dataset.id = book.id;
      div.style.backgroundImage = `url(${book.cover})`;

      const activate = () => {
        setActiveBook(book.id);
        div.scrollIntoView({ behavior: 'smooth', inline: 'center', block: 'nearest' });
      };

      div.addEventListener('click', activate);
      div.addEventListener('keydown', e => {
        if (e.key === 'Enter' || e.key === ' ') {
          e.preventDefault();
          activate();
        }
      });

      carousel.appendChild(div);
    });
  }

  function addNavigationButtons() {
    const leftBtn = document.createElement('button');
    leftBtn.textContent = '←';
    leftBtn.className = 'carousel-nav left';
    leftBtn.addEventListener('click', () => {
      carousel.scrollBy({ left: -200, behavior: 'smooth' });
    });

    const rightBtn = document.createElement('button');
    rightBtn.textContent = '→';
    rightBtn.className = 'carousel-nav right';
    rightBtn.addEventListener('click', () => {
      carousel.scrollBy({ left: 200, behavior: 'smooth' });
    });

    carousel.parentElement.appendChild(leftBtn);
    carousel.parentElement.appendChild(rightBtn);
  }

  commentForm.addEventListener('submit', e => {
    e.preventDefault();
    const text = commentInput.value.trim();
    if (!text) return;

    const comments = loadComments(activeBookId);
    comments.push(text);
    saveComments(activeBookId, comments);
    renderComments(activeBookId);
    commentInput.value = '';
    commentInput.focus();
  });

  createCarouselCovers();
  addNavigationButtons();

  if (books.length > 0) {
    setActiveBook(books[0].id);
  }

  function scrollCarousel(direction) {
    const carousel = document.querySelector('.carousel');
    const scrollAmount = 300; // ajuste conforme necessário
    carousel.scrollBy({
      left: direction * scrollAmount,
      behavior: 'smooth'
    });
  }

})();


</script>
